**************************************************************
* Read in data
**************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_monthly.dta, clear

**************************************************************
* Data work
**************************************************************

* Variables

forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1960m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=tm(2022m9))

local latest = tm(2022m9)

**************************************************************
* Variables
**************************************************************

* Inflation gap
cap drop y x*
g y		= Median-pe

* Relative price fluctuations (supply fluctuations)
g z			= CPI - Median
* 12-month average
gen z_12ma	= (1/12)*(z + z[_n-1] + z[_n-2] + z[_n-3] + z[_n-4] + z[_n-5] + z[_n-6] + z[_n-7] + z[_n-8] + z[_n-9] + z[_n-10] + z[_n-11])

* Measure of slack
foreach var in vu {
	* Define measure of slack ("x")
	cap drop x*
	g x		= `var'_12ma
	g x2	= x^2
	g x3	= x^3
	* Compute nonlinear "z" terms
	g z_12ma2 = z_12ma^2
	g z_12ma3 = z_12ma^3	
}

**************************************************************
//* Estimation and chart: 1985-2022
**************************************************************

local index = 1
local title = "A. Sample: 1985-2022"

preserve
newey y x x2 x3 z_12ma z_12ma2 z_12ma3 if (sample3==1|sample4==1), lag(12)

* Compute contributions

* Fitted values
cap drop yhat* serror* hi lo 
predict yhat
predict serror, stdp
g hi = yhat + 1.96*serror
g lo = yhat - 1.96*serror

* Print variance-covariance matrix
estat vce

* Fitted values with no "H" shocks
g yhat_noH			= _b[_cons] + (_b[x]*x) + (_b[x2]*x2) + (_b[x3]*x3)

label variable y "Actual"
label variable yhat "Fitted values"
label variable yhat_noH "Fitted values assuming no headline inflation shocks"

* Chart

keep if (t>=tm(2020m1) & t<=`latest')

sum t
local t0 = r(min)
local t1 = r(max)

twoway (line y yhat yhat_noH t, yline(0, lcolor(ebg)) lcolor(blue midblue red) lpattern(solid dash shortdash) ///
ylabel(-2(2)10) ///
lwidth(medthick medthick medthick) xtitle("") xmtick(#31) xlabel(`t0'(12)`t1', format(%tmCY)) ///
legend(row(3) symxsize(4) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(1 2 3)) ///
legend(size(medium)) ///
title("`title'") ///
saving(`index'.gph, replace))
g yhat_H = yhat - yhat_noH
clist t y yhat yhat_noH yhat_H Median pe CPI z, noobs
rename y Actual
rename yhat Fitted
rename yhat_noH Fitted_noH
outsheet Actual Fitted Fitted_noH t using "results\charts\Figure 7 Panel A.xls", replace
restore
*/

**************************************************************
* Estimation and chart: 1985-2019
**************************************************************

local index = 2
local title = "B. Sample: 1985-2019"

preserve
newey y x x2 x3 z_12ma z_12ma2 z_12ma3 if (sample3==1), lag(12)

* Compute contributions

* Fitted values
cap drop yhat* serror* hi lo 
predict yhat
predict serror, stdp
g hi = yhat + 1.96*serror
g lo = yhat - 1.96*serror

* Print variance-covariance matrix
estat vce

* Fitted values with no "H" shocks
g yhat_noH			= _b[_cons] + (_b[x]*x) + (_b[x2]*x2) + (_b[x3]*x3)

label variable y "Actual"
label variable yhat "Fitted values"
label variable yhat_noH "Fitted values assuming no headline inflation shocks"

* Chart

keep if (t>=tm(2020m1) & t<=`latest')

sum t
local t0 = r(min)
local t1 = r(max)

twoway (line y yhat yhat_noH t, yline(0, lcolor(ebg)) lcolor(blue midblue red) lpattern(solid dash shortdash) ///
ylabel(-2(2)10) ///
lwidth(medthick medthick medthick) xtitle("") xmtick(#31) xlabel(`t0'(12)`t1', format(%tmCY)) ///
legend(row(3) symxsize(4) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(1 2 3)) ///
legend(size(medium)) ///
title("`title'") ///
saving(`index'.gph, replace))
clist t y yhat yhat_noH, noobs
rename y Actual
rename yhat Fitted
rename yhat_noH Fitted_noH
outsheet Actual Fitted Fitted_noH t using "results\charts\Figure 7 Panel B.xls", replace
restore

* Combine charts

graph combine 1.gph 2.gph, row(2) ysize(8)
